-- Plugin
global nvpx
global PhysXModRB

global PxIsBone
global PxGetRootParent

-- note: ragdoll rb type is  different to the type of one rb, which is defined as PX_PHYSTYPE_DYNAMIC/PX_PHYSTYPE_KINEMATIC/PX_PHYSTYPE_STATIC
global PX_RAGDOLL_RBTYPE_KINEMATIC = 0
global PX_RAGDOLL_RBTYPE_DYNAMIC = 1

global PX_RAGDOLL_MESHTYPE_CAPSULE = 0
global PX_RAGDOLL_MESHTYPE_CONVEX = 1

global PX_RAGDOLL_MESHFROM_SKIN = 0
global PX_RAGDOLL_MESHFROM_BONE = 1

fn PxGetRagdollHelperRootBone n =
(
	root = PxGetRootParent(n)
	handle = (getuserprop root "RagdollMesh")
	if handle != undefined then (
		root
	) else if PxIsBone(n) then (
		root
	)
	else (
		root = nvpx.RagdollGetRootBone n
	)
)

fn PxPotentialRagdollHelper n =
(
	-- it should be a bone or a skinned mesh
	if PxIsBone(n) then
	(
		if ((classof n) == CATBone) or ((classof n) == HubObject) then
			false
		else
			true
	)
	else
	(
		ret = false
		m = n.modifiers[#Physique]
		if m == undefined then m = n.modifiers[#Skin]
		(m != undefined)
	)
)


fn PxGetRagdollHelper n =
(
	if classof(n) == RagdollHelper then n
	else
	(
		ret = undefined
		root = PxGetRootParent(n)
		for i in objects do (
			if classof(i) == RagdollHelper then (
				if i.rootbone == root then ( ret = i; exit )
				-- iterates on multiple ragdoll skins
				for skin in i.multiRagdollSkins do
				(
					if skin == root then ( ret = i; exit )
				)
			)
		)
		ret
	)
)

fn PxGetRagdollHelperNode n =
(
	if nvpx.IsRagdollNode(n) then n
	else
	(
		ret = undefined
		root = PxGetRootParent(n)
		for i in objects do (
			if nvpx.RagdollGetRootBone(i) == root then (
				ret = i
				exit
			)
		)
		ret
	)
)

fn PxCreateDynamicRagdoll n =
(
	ret = undefined
	if n !=undefined and (PxPotentialRagdollHelper(n) or (classof(n) == RagdollHelper )) then (
		local setKeyMode = maxOps.setKeyMode
		maxOps.setKeyMode = false
		
		rag = PxGetRagdollHelper(n)
		--format " find rag %\n" rag
		if rag != undefined then (
			select rag
			 --forces a reset
			rag.rbtype = PX_RAGDOLL_RBTYPE_DYNAMIC
			rag.create(true)
			max modify mode
			ret = rag
		) else (
			rootBone = PxGetRagdollRootBone(n)
			if rootBone == undefined then 
			(
				messagebox nvpxText.TXT_RAGDOLL_ERR_UNKNOWN
			)
			else
			(
				rag = nvpx.CreateRagdollHelper()
				rag.rbtype = PX_RAGDOLL_RBTYPE_DYNAMIC
				rag.rootbone = rootBone
				--rag.pos = rootBone.transform.pos
				ragdollskin = PxGetRagdollHelperNode n
				if (ragdollskin != undefined) do
					append rag.multiRagdollSkins ragdollskin
				-- if there is skin, Graphical Mesh From uses 'skinned mesh'. If not, uses 'bones'
				rag.meshfrom = 1
				for skin in rag.multiRagdollSkins do
				(
					if skin != undefined then rag.meshfrom = 0
				)
				rag.create(false) -- rag.handle
				max modify mode
				select rag
				ret = rag
			)
		)
		
		maxOps.setKeyMode = setKeyMode
	)
	ret
)


fn PxCreateDynamicRagdollHelper =
(
	currentNode = PxGetCurrentNode()
	if currentNode != undefined then
		PxCreateDynamicRagdoll(currentNode)
)

fn PxCreateKinematicRagdoll n =
(
	ret = undefined
	if n !=undefined and (PxPotentialRagdollHelper(n) or (classof(n) == RagdollHelper )) then (
		local setKeyMode = maxOps.setKeyMode
		maxOps.setKeyMode = false
		
		rag = PxGetRagdollHelper(n)
		--format " find rag %\n" rag
		if rag != undefined then (
			select rag
			rag.rbtype = PX_RAGDOLL_RBTYPE_KINEMATIC
			-- forces a reset
			rag.create(true)
			max modify mode
			ret = rag
		) else (
			rootBone = PxGetRagdollHelperRootBone(n)
			if rootBone == undefined then 
			(
				messagebox nvpxText.ragdollErrorNoRoot
			)
			else
			(
				rag = nvpx.CreateRagdollHelper()
				rag.rbtype = PX_RAGDOLL_RBTYPE_KINEMATIC
				rag.rootBone = rootBone
				rag.pos = rootBone.transform.pos
				ragdollskin = PxGetRagdollHelperNode n
				if (ragdollskin != undefined) do
					append rag.multiRagdollSkins ragdollskin
				-- if there is skin, Graphical Mesh From uses 'skinned mesh'. If not, uses 'bones'
				rag.meshfrom = 1
				for skin in rag.multiRagdollSkins do
				(
					if skin != undefined then rag.meshfrom = 0
				)
				rag.create(false) -- 
				max modify mode
				select rag
				ret = rag
			)
		)

		maxOps.setKeyMode = setKeyMode
	)
	ret
)

fn PxCreateKinematicRagdollHelper =
(
	currentNode = PxGetCurrentNode()
	if currentNode != undefined then
		PxCreateKinematicRagdoll currentNode
)

fn PxRemoveRagdollByNode node = 
(
	if node != undefined then 
	(
		rag = PxGetRagdollHelper(node)
		if rag != undefined then 
		(
			info = nvpxText.ragdollDeleteRB
			yes  = queryBox info
			if yes then 
			(
				rag.removeAll()
			)
			else
			( 
				rag.disconnectAll()
			)
			delete rag
		)
	)
)

fn PxRemoveRagdollHelper =
(
	selNodes = PxGetSelectedNodes()
	
	for currentNode in selNodes do
	( 
		PxRemoveRagdollByNode currentNode
	)
	selHelper = PxGetSelectedHelpers()
	
	for currentNode in selHelper do
	( 
		PxRemoveRagdollByNode currentNode	
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBL/rUBh/UbGjstPpfJFXj8VawU2KWhCwPH
-- lm4HoKsCPCuupYuBBVnj3v6FN/Ff/xIammX17ZQ7rB0NZvnqY73y1kkvOTi68ECB
-- 7fVBJ/yUMZlWbdf3sVvoNNi+J7qPOh4y3v8QYU74ILnxtusBt/8Cnhvhew71D5qp
-- BV5st4LCS5u9bbjd2W52enQTvjcOfw8HUi0MCdLGyYr0fI1/JlLv7gHWzaYGS+kn
-- Z24oSESvYONXigoh+O+Jy4yMhROL9MYdVU9IAfXQb/tcIMQKFWHX6ZRg4ei66aYh
-- FRgsrGoWaf0+KHNW9x0n0r1TcvnN/mRnuYdyQp3SZvOTsW3YKSwS
-- -----END-SIGNATURE-----